% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_plot.R
\name{MCMC_plot}
\alias{MCMC_plot}
\title{MCMC trajectories and posterior distributions plot}
\usage{
MCMC_plot(sample, size, SampleNames, Nb_sample = 1, Nb_chaines = 3,
  value = c(0, Nb_sample, 2 * Nb_sample), param = c("A", "D", "sD"))
}
\arguments{
\item{sample}{MCMC.list: that is generated by \code{\link{jags.model}} in \code{\link{Age_Computation}}.}

\item{size}{integer: length of each chain.}

\item{SampleNames}{character vector: names of the samples, used in the figure titles.}

\item{Nb_sample}{integer (with default): number of analysed samples.}

\item{Nb_chaines}{integer (with default): number of independent chains for the model (for more informations, see \code{\link{jags.model}}).}

\item{value}{integer vector (with default): position idex used to select age (if available), palaeodose and equivalent dose dispersion parameters for the first sample.}

\item{param}{character vector (with default): names of the selected parameters with value \code{A} for age (if available),
\code{D} for palaeodose and \code{sD} for equivalent dose dispersion.}
}
\value{
A pdf file with the MCMC trajectories and posterior distributions for each parameter defined in \code{param}.
There is one page per sample, which is divided by \code{length(param)} vertically and by \code{2} horizontally. \cr
The first line of the figure correponds to the first parameter defined in \code{param}, and so on.
On each line, the plot on the left represents the MCMC trajectories, and the one on the right the posterior distributions of the parameter.
}
\description{
This function uses the ouput of \code{\link{coda.samples}} to plot the trajectories of MCMC and densities of the posterior distributions
of the age - if it is calculated, palaeodose and equivalent dose dispersion parameters of the sample.
This function is used in the function \code{\link{Age_Computation}}, \code{\link{AgeS_Computation}} and \code{\link{Palaeodose_Computation}}.
}
\examples{
data(MCMCsample,envir = environment())
MCMC_plot(sample=MCMCsample,size=2000,SampleNames="GDB3")

}
\seealso{
\code{\link{Age_Computation}}, \code{\link{AgeS_Computation}}, \code{\link{Palaeodose_Computation}},
 \code{\link{coda.samples}} and \code{\link{rjags}} packages.
}
\author{
Claire Christophe, Anne Philippe, Guillaume Guerin
}
