\name{makeClusterFunctions}
\alias{ClusterFunctions}
\alias{makeClusterFunctions}
\title{Create a ClusterFuntions object.}
\usage{
makeClusterFunctions(name, submitJob, killJob, listJobs, getArrayEnvirName,
  class = NULL, ...)
}
\arguments{
  \item{name}{[\code{character(1)}]\cr Name of cluster
  functions.}

  \item{submitJob}{[\code{function(conf, reg, job.name,
  rscript, log.file, job.dir, resources, ...)}]\cr Function
  to submit a new job.  Must return a
  \code{\link{SubmitJobResult}} object.\cr The arguments
  are:\cr conf [\code{environment}]: The user
  configuration.\cr reg [\code{\link{Registry}}]: The
  registry.\cr job.name [\code{character(1)}]: Name of job,
  used if the job is displayed on the batch system. This is
  just for display and not an id!\cr rscript
  [\code{character(1)}]: File path to R script that is used
  to execute the job.\cr log.file [\code{character(1)}]:
  File path where log file (.Rout) has to be placed.\cr
  job.dir [\code{character(1)}]: Directory where all files
  relating to this job are placed.\cr resources
  [\code{list}]: Freely definable list of required
  resources for this job, e.g. walltime or memory.}

  \item{killJob}{[\code{function(conf, reg,
  batch.job.id)}]\cr Function to kill a job on the batch
  system.  Make sure that you definately kill the job!
  Return value is currently ignored.\cr The arguments
  are:\cr conf [\code{environment}]: The user
  configuration.\cr reg [\code{\link{Registry}}]: The
  registry.\cr batch.job.id [\code{character(1)}]: Batch
  job id, as produced by \code{submitJob}.\cr Set
  \code{killJob} to \code{NULL} if killing jobs cannot be
  supported.}

  \item{listJobs}{[\code{function(conf, reg)}]\cr List all
  jobs on the batch system for the current user / registry.
  This includes queued, running, held, idle, etc. jobs.
  Must return an integer vector of batch job ids, same
  format as they are produced by \code{submitJob}.  It does
  not matter if you return a few job ids too many (e.g. all
  for the current user instead of all for the current
  registry), but you have to include all relevant ones.
  The arguments are:\cr conf [\code{environment}]: The user
  configuration.\cr reg [\code{\link{Registry}}]: The
  registry.\cr Set \code{listJobs} to \code{NULL} if
  listing jobs cannot be supported.}

  \item{getArrayEnvirName}{[\code{function()}]\cr Returns
  the name of the environment variable specifying the array
  ID.  Should return \code{NA} if not supported.}

  \item{class}{[\code{character(1)}]\cr Optional class name
  for cluster functions object.  Useful to provide a nice
  print method which might show additional information
  about the workers.  Default is \code{NULL}.}

  \item{...}{[\code{any}]\cr Currently ignored.}
}
\description{
Use this funtion when you implement a backend for a batch
system. You must define the functions specified in the
arguments.
}
\seealso{
\code{\link{makeClusterFunctionsInteractive}},
\code{\link{makeClusterFunctionsLocal}},
\code{\link{makeClusterFunctionsMulticore}},
\code{\link{makeClusterFunctionsSSH}},
\code{\link{makeClusterFunctionsTorque}},
\code{\link{makeClusterFunctionsSGE}},
\code{\link{makeClusterFunctionsSLURM}}
}

