#' A subset of symbols related to sets
#'
#' Name and symbol of operations related to sets, including intersection
#' and union among others:
#' @references
#' \url{https://www.fileformat.info/info/unicode/category/Sm/list.htm}
#' @export
#' @examples
#' set_symbols
set_symbols <- c(
    "intersection" = "\u2229",
    "union" = "\u222A",
    "complement" = "\u2201",
    "negation" = "\u00AC",
    "subsetOrEqual" = "\u2286",
    "supersetOrEqual" = "\u2287",
    "notSubset" = "\u2284",
    "notSuperset" = "\u2285",
    "element" = "\u2208",
    "notElement" = "\u2209",
    "empty" = "\u2205",
    "contains" = "\u220B",
    "notContained" = "\u220C",
    "minus" = "\u2216",
    "product" = "\u2A2F",
    "conditional" = "|"
)
