% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barcoding.spe.identify2.R
\name{barcoding.spe.identify2}
\alias{barcoding.spe.identify2}
\title{Species Identification Based on Fuzzy-set Method and kmer}
\usage{
barcoding.spe.identify2(ref, que, kmer = kmer, optimization = TRUE)
}
\arguments{
\item{ref}{object of class "DNAbin" used as a reference dataset, which contains taxon information.}

\item{que}{object of class "DNAbin", whose identities (species names) need to be inferred.}

\item{kmer}{a numeric to indicate the length of maximum kmer to try in the range of 1 to kmer in case of
optimization = TRUE, otherwise, only a certain length of kmer is used.}

\item{optimization}{a character string, indicating whether different length of kmer (up to kmer) will be used or
just a specified length of kmer will be used.}
}
\value{
a list indicating the identified species.
}
\description{
Species identification based on fuzzy-set method (Zhang et al. 2012)and kmer.
}
\note{
read.dna() from package {ape} was used to obtain DNAbin object for unaligned non-coding barcodes.
}
\examples{

data(pineMothITS2) 
ref<-pineMothITS2
que<-ref
spe.id<-barcoding.spe.identify2(ref,que, kmer = 1, optimization = FALSE)
spe.id
 
}
\author{
Ai-bing ZHANG, Cai-qing YANG, Meng-di HAO, CNU, Beijing, CHINA, contact at zhangab2008 (at) mail. cnu. edu. cn.
}
\references{
Zhang, A.B, Hao, M.D., Yang,C.Q., Shi, Z.Y. (2016). BarcodingR: an integrated R package for species identification using DNA barcodes. Methods in Ecology and Evolution. In press.

Jin,Q., H.L. Han, X.M. Hu, X.H. Li,C.D. Zhu,S. Y. W. Ho, R. D. Ward, A.B. Zhang . (2013).Quantifying Species Diversity with a DNA Barcoding-Based Method: Tibetan Moth Species (Noctuidae) on the Qinghai-Tibetan Plateau. PloS One 8: e644.

Zhang, A. B., C. Muster, H.B. Liang, C.D. Zhu, R. Crozier, P. Wan, J. Feng, R. D. Ward.(2012). A fuzzy-set-theory-based approach to analyse species membership in DNA barcoding. Molecular Ecology, 21(8):1848-63.

Zhang, A. B., D. S. Sikes, C. Muster, S. Q. Li. (2008). Inferring Species Membership using DNA sequences with Back-propagation Neural Networks. Systematic Biology, 57(2):202-215.
}
\keyword{barcoding.spe.identify2}

