% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{class}
\name{Arena-class}
\alias{Arena-class}
\title{Structure of the S4 class "Arena"}
\description{
Structure of the S4 class \code{Arena} to represent the environment in which Organisms and Substances interact.
}
\section{Slots}{

\describe{
\item{\code{orgdat}}{A data frame collecting information about the accumulated biomass, type, phenotype, x and y position for each individual in the environment.}

\item{\code{specs}}{A list of organism types and their associated parameters.}

\item{\code{media}}{A list of objects of class \code{\link{Substance-class}} for each compound in the environment.}

\item{\code{phenotypes}}{A list of unique phenotypes (metabolites consumed and produced), which occurred in the environment.}

\item{\code{mediac}}{A character vector containing the names of all substances in the environment.}

\item{\code{tstep}}{A number giving the time (in h) per iteration.}

\item{\code{stir}}{A boolean variable indicating if environment should be stirred. If true, bacteria move to random positions within the environment and substances have a uniform concentration value.}

\item{\code{mflux}}{A vector containing highly used metabolic reactions within the arena}

\item{\code{shadow}}{A vector containing shadow prices of metabolites present in the arena}

\item{\code{n}}{A number giving the horizontal size of the environment.}

\item{\code{m}}{A number giving the vertical size of the environment.}

\item{\code{Lx}}{A number giving the horizontal grid size in cm.}

\item{\code{Ly}}{A number giving the vertical grid size in cm.}

\item{\code{gridgeometry}}{A list containing grid geometry parameter}

\item{\code{seed}}{An integer refering to the random number seed used to be reproducible}

\item{\code{scale}}{A numeric defining the scale factor used for intern unit conversion.}

\item{\code{models}}{A list containing Objects of class sybil::modelorg which represent the genome scale metabolic models}

\item{\code{occupyM}}{A matrix indicating grid cells that are obstacles}

\item{\code{sublb}}{A data matrix containing positions with amounts of substance for all organism}
}}

