% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_preds.R
\name{plot_preds}
\alias{plot_preds}
\title{Make a scatterplot of observed vs. predicted values}
\usage{
plot_preds(pred, true, show.na = T, ...)
}
\arguments{
\item{pred}{matrix or vector of predicted values}

\item{true}{matrix or vector of predicted values}

\item{show.na}{logical, display NA values as blue dots at the mean for the x or y axis (def: T)}

\item{...}{other parameters passed to plot}
}
\value{
none
}
\description{
If there are more than 25,0000 points then they are subsampled down to 25,000.
Observed values are on the x axis predicted values on the y. A blue line shows the 
diagonal. Points are transparent to show dense clusters. Predictions for points where
the true value is not known are plotted at zero in blue.
}
\examples{
x <- seq(-10,10, 0.01)+rnorm(2001)
y <- seq(-10,10, 0.01)+rnorm(2001)
x[sample(2001, 100)] <- NA
plot_preds(y, x)
}

