% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,NHPP-method}
\alias{simulate,NHPP-method}
\title{Simulation of Poisson process}
\usage{
\S4method{simulate}{NHPP}(object, nsim = 1, seed = NULL, t,
  plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "NHPP"}

\item{nsim}{number of trajectories to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of non-homogeneous Poisson process with cumulative intensity function \eqn{\Lambda(t, \xi)}.
}
\examples{
model <- set.to.class("NHPP", parameter = list(xi = c(5, 1/2)),
                      Lambda = function(t, xi) (t/xi[2])^xi[1])
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t)
}

