% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict,est.Diffusion-method}
\alias{predict,est.Diffusion-method}
\title{Prediction for a diffusion process}
\usage{
\S4method{predict}{est.Diffusion}(object, t, Euler.interval = FALSE,
  level = 0.05, burnIn, thinning, b.fun.mat, which.series = c("new",
  "current"), y.start, M2pred = 10, cand.length = 1000,
  pred.alg = c("Distribution", "Trajectory", "simpleTrajectory",
  "simpleBayesTrajectory"), method = c("vector", "free"),
  sampling.alg = c("InvMethod", "RejSamp"), sample.length, grid,
  plot.prediction = TRUE)
}
\arguments{
\item{object}{class object of MCMC samples: "est.Diffusion", created with method \code{\link{estimate,Diffusion-method}}}

\item{t}{vector of time points to make predictions for}

\item{Euler.interval}{if TRUE: simple prediction intervals with Euler are made (in one step each)}

\item{level}{level of the prediction intervals}

\item{burnIn}{burn-in period}

\item{thinning}{thinning rate}

\item{b.fun.mat}{matrix-wise definition of drift function (makes it faster)}

\item{which.series}{which series to be predicted, new one ("new") or further development of current one ("current")}

\item{y.start}{optional, if missing, first (which.series = "new") or last observation variable ("current") is taken}

\item{M2pred}{optional, if current series to be predicted and t missing, \code{M2pred} variables will be predicted
with the observation time distances}

\item{cand.length}{length of candidate samples (if method = "vector")}

\item{pred.alg}{prediction algorithm, "Distribution", "Trajectory", "simpleTrajectory" or "simpleBayesTrajectory"}

\item{method}{vectorial ("vector") or not ("free")}

\item{sampling.alg}{sampling algorithm, inversion method ("InvMethod") or rejection sampling ("RejSamp")}

\item{sample.length}{number of samples to be drawn, default is the number of posterior samples}

\item{grid}{fineness degree of sampling approximation}

\item{plot.prediction}{if TRUE, prediction intervals are plotted}
}
\description{
Bayesian prediction of a stochastic process
  \eqn{dY_t = b(\phi,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t}.
}
\examples{
model <- set.to.class("Diffusion", parameter = list(phi = 0.5, gamma2 = 0.01))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, y0 = 0.5)
est_diff <- estimate(model, t, data, 1000) # better: 10000
plot(est_diff)
\dontrun{
pred_diff <- predict(est_diff, t = seq(0, 1, by = 0.1))
pred_diff <- predict(est_diff, b.fun.mat = function(phi, t, y) phi[,1])  # much faster
pred_diff2 <- predict(est_diff, which.series = "current", b.fun.mat = function(phi, t, y) phi[,1])
pred_diff3 <- predict(est_diff, which.series = "current", y.start = data[51],
               t = t[seq(51, 100, by = 5)], b.fun.mat = function(phi, t, y) phi[,1])
}
pred_diff <- predict(est_diff, Euler.interval = TRUE, b.fun.mat = function(phi, t, y) phi[,1])
# one step Euler approximation
pred_diff <- predict(est_diff, pred.alg = "simpleTrajectory", sample.length = 100)
for(i in 1:100) lines(t[-1], pred_diff[i,], col = "grey")
pred_diff <- predict(est_diff, pred.alg = "simpleBayesTrajectory")
}
\references{
Hermann, S. (2016a). BaPreStoPro: an R Package for Bayesian Prediction of Stochastic Processes.
SFB 823 discussion paper 28/16.

Hermann, S. (2016b). Bayesian Prediction for Stochastic Processes based on the Euler Approximation Scheme.
SFB 823 discussion paper 27/16.
}

