% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/helpingFunctions.R
\name{RejSampling}
\alias{RejSampling}
\title{Rejection Sampling Algorithm}
\usage{
RejSampling(Fun, dens, len, cand, grid = 0.001, method = c("vector",
  "free"))
}
\arguments{
\item{Fun}{cumulative distribution function}

\item{dens}{density}

\item{len}{number of samples}

\item{cand}{candidate area}

\item{grid}{fineness degree}

\item{method}{vectorial ("vector") or not ("free")}
}
\description{
Algorithm to sample from an arbitrary density function.
}
\examples{
plot(density(RejSampling(dens = function(x) dnorm(x, 5, 1),
   len = 500, cand = seq(2, 9, by = 0.001), method = "free")))
lines(density(RejSampling(dens = function(x) dnorm(x, 5, 1), len = 500,
      cand = seq(2, 9, by = 0.001), method = "vector")), col=2)
curve(dnorm(x, 5, 1), from = 2, to = 8, add = TRUE, col = 3)
}
\references{
Devroye, L. (1986). Non-Uniform Random Variate Generation. New York: Springer.
}

