% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/84_plot_hyper.R
\name{bv_plot_trace}
\alias{bv_plot_trace}
\alias{bv_plot_density}
\title{Hyperparameter trace & density plot}
\usage{
bv_plot_trace(x, name, ...)

bv_plot_density(x, name, ...)
}
\arguments{
\item{x}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{name}{String with the name of the hyperparameter to plot. Possible
values are names of hyperparameters and \code{"ml"} for the posterior
marginal likelihood.}

\item{...}{Further \code{bvar} objects to include in the plot. The desired
hyperparameter must be available and priors of the objects should match.}
}
\description{
Diagnostic plots of the trace / density of a single hyperparameter.
A parameter may be plotted across multiple iterations of \code{\link{bvar}}
via the ellipsis parameter. Given that the settings for \code{\link{bvar}}
are identical this can be used to assess convergence.
}
\examples{
\donttest{
data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2)

# Plot the trace of lambda
bv_plot_trace(x, "lambda")

# Adjust par() and plot the density of the posterior marginal likelihood
op <- par(mar = c(2, 2, 2, 0.5))
bv_plot_density(x, "ml")
par(op)

# Assess parameter convergence of several chains via their trace
y <- bvar(data, lags = 2)
z <- bvar(data, lags = 2)
bv_plot_trace(x, "lambda", y, z)
}
}
