% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{elog2cbs}
\alias{elog2cbs}
\title{Convert Event Log to customer-level summary statistic}
\usage{
elog2cbs(elog, units = "week", T.cal = NULL, T.tot = NULL)
}
\arguments{
\item{elog}{Event log, a \code{data.frame} with field \code{cust} for the
customer ID and field \code{date} for the date/time of the event, which
should be of type \code{Date} or \code{POSIXt}. If a field \code{sales} is
present, it will be aggregated as well.}

\item{units}{Time unit, either \code{week}, \code{day}, \code{hour},
\code{min} or \code{sec}. See \code{\link[base]{difftime}}.}

\item{T.cal}{End date of calibration period. Defaults to
\code{max(elog$date)}.}

\item{T.tot}{End date of the observation period. Defaults to
\code{max(elog$date)}.}
}
\value{
\code{data.frame} with fields:
 \item{\code{cust}}{Customer id (unique key).}
 \item{\code{x}}{Number of recurring events in calibration period.}
 \item{\code{t.x}}{Time between first and last event in calibration period.}
 \item{\code{litt}}{Sum of logarithmic intertransaction timings during calibration period.}
 \item{\code{sales}}{Sum of sales in calibration period. Only if \code{elog$sales} is provided.}
 \item{\code{first}}{Date of first transaction in calibration period.}
 \item{\code{T.cal}}{Time between first event and end of calibration period.}
 \item{\code{T.star}}{Length of holdout period. Only if \code{T.cal} is provided.}
 \item{\code{x.star}}{Number of events within holdout period. Only if \code{T.cal} is provided.}
 \item{\code{sales.star}}{Sum of sales within holdout period. Only if \code{T.cal} and \code{elog$sales} are provided.}
}
\description{
Efficient implementation for the conversion of an event log into a
customer-by-sufficient-statistic (CBS) \code{data.frame}, with a row for each
customer, which is the required data format for estimating model parameters.
}
\details{
The time unit for expressing \code{t.x}, \code{T.cal} and \code{litt} are
determined via the argument \code{units}, which is passed forward to method
\code{difftime}, and defaults to \code{weeks}.

Argument \code{T.tot} allows one to specify the end of the observation period,
i.e. the last possible date of an event to still be included in the event
log. If  \code{T.tot} is not provided, then the date of the last recorded event
will be assumed to coincide with the end of the observation period. If
 \code{T.tot} is provided, then any event that occurs after that date is discarded.

Argument \code{T.cal} allows one to split the summary statistics into a
calibration and a holdout period. This can be useful for evaluating
forecasting accuracy for a given dataset. If \code{T.cal} is not provided,
then the whole observation period is considered, and is then subsequently
used for for estimating model parameters. If it is provided, then the
returned \code{data.frame} contains two additional fields, with \code{x.star}
representing the number of repeat transactions during the holdout period of
length \code{T.star}. And only those customers are contained, who have had at
least one event during the calibration period.

Transactions with identical \code{cust} and \code{date} field are treated as
a single transaction, with \code{sales} being summed up.
}
\examples{
data("groceryElog")
cbs <- elog2cbs(groceryElog, T.cal = "2006-12-31", T.tot = "2007-12-30")
head(cbs)
}

