% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTLLasso-package.R
\docType{data}
\name{Buli1516}
\alias{Buli1516}
\title{Bundesliga Data 2015/16 (Buli1516)}
\format{A list containing data from the German Bundesliga with 306 observations. 
The list contains both information on the response (paired comparisons) and different covariates.
\describe{ 
\item{Y}{A response.BTLLasso object for the Buli1516 data including
\itemize{
\item{response: Ordinal paired comparison response vector} 
\item{first.object: Vector containing the first-named team per paired comparison (home team)}
\item{second.object: Vector containing the second-named team per paired comparison (away team)}
\item{subject: Vector containing a match-day identifier per paired comparison}
}}
\item{Z1}{Matrix containing all team-match-specific covariates
\itemize{
\item{Distance: Total amount of km run} 
\item{BallPossession: Percentage of ball possession}
\item{TacklingRate: Rate of won tacklings}
\item{ShotsonGoal: Total number of shots on goal} 
\item{CompletionRate: Percentage of passes reaching teammates} 
\item{FoulsSuffered: Number of fouls suffered} 
\item{Offside: Number of offsides (in attack)}
}
}
\item{Z2}{Matrix containing all the average market values of the teams as a team-specific covariate} 
}}
\source{
\url{http://www.kicker.de/}
}
\description{
Data from the German Bundesliga from the season 2015/16. 
The data contain all 306 matches of the season treated as paired comparisons with 5 different 
response categories. Additionally, different match-specific covariates are given as, for example, 
the percentage of ball possession or the total distance ran per team and per match.
}
\examples{

data(Buli1516)

}
\references{
Schauberger, Gunther and Tutz, Gerhard (2015): Modelling Heterogeneity in
Paired Comparison Data - an L1 Penalty Approach with an Application to Party
Preference Data, \emph{Department of Statistics, LMU Munich}, Technical
Report 183
}
\keyword{datasets}

