% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BT_Call.R
\name{BT_call}
\alias{BT_call}
\alias{BT_callInit}
\alias{BT_callBoosting}
\title{(Adaptive) Boosting Trees (ABT/BT) fit.}
\usage{
BT_call(
  training.set,
  validation.set,
  tweedie.power,
  respVar,
  w,
  explVar,
  ABT,
  tree.control,
  train.fraction,
  interaction.depth,
  bag.fraction,
  shrinkage,
  n.iter,
  colsample.bytree,
  keep.data,
  is.verbose
)

BT_callInit(training.set, validation.set, tweedie.power, respVar, w)

BT_callBoosting(
  training.set,
  validation.set,
  tweedie.power,
  ABT,
  tree.control,
  interaction.depth,
  bag.fraction,
  shrinkage,
  n.iter,
  colsample.bytree,
  train.fraction,
  keep.data,
  is.verbose,
  respVar,
  w,
  explVar
)
}
\arguments{
\item{training.set}{a data frame containing all the related variables on which one wants to fit the algorithm.}

\item{validation.set}{a held-out data frame containing all the related variables on which one wants to assess the algorithm performance. This can be NULL.}

\item{tweedie.power}{Experimental parameter currently not used - Set to 1 referring to Poisson distribution.}

\item{respVar}{the name of the target/response variable.}

\item{w}{a vector of weights.}

\item{explVar}{a vector containing the name of explanatory variables.}

\item{ABT}{a boolean parameter. If \code{ABT=TRUE} an adaptive boosting tree algorithm is built whereas if \code{ABT=FALSE} an usual boosting tree algorithm is run.}

\item{tree.control}{allows to define additional tree parameters that will be used at each iteration. See \code{\link{rpart.control}} for more information.}

\item{train.fraction}{the first \code{train.fraction * nrows(data)} observations are used to fit the \code{BT} and the remainder are used for
computing out-of-sample estimates (also known as validation error) of the loss function. It is mainly used to report the value in the \code{BTFit} object.}

\item{interaction.depth}{the maximum depth of variable interactions: 1 builds an additive model, 2 builds a model with up to two-way interactions, etc.
This parameter can also be interpreted as the maximum number of non-terminal nodes. By default, it is set to 4.
Please note that if this parameter is \code{NULL}, all the trees in the expansion are built based on the \code{tree.control} parameter only.
This option is devoted to advanced users only and allows them to benefit from the full flexibility of the implemented algorithm.}

\item{bag.fraction}{the fraction of independent training observations randomly selected to propose the next tree in the expansion.
This introduces randomness into the model fit. If \code{bag.fraction}<1 then running the same model twice will result in similar but different fits.
\code{BT} uses the R random number generator, so \code{set.seed} ensures the same model can be reconstructed. Please note that if this parameter is used the \code{BTErrors$training.error}
corresponds to the normalized in-bag error}

\item{shrinkage}{a shrinkage parameter applied to each tree in the expansion. Also known as the learning rate or step-size reduction.}

\item{n.iter}{the total number of iterations to fit. This is equivalent to the number of trees and the number of basis function in the additive expansion.
Please note that the initialization is not taken into account in the \code{n.iter}. More explicitly, a first GLM initializes the algorithm and then \code{n.iter} trees
are built. Moreover, note that the \code{bag.fraction}, \code{colsample.bytree}, ... are not used for this initializing phase.}

\item{colsample.bytree}{each tree will be trained on a random subset of \code{colsample.bytree} number of features. Each tree will consider a new
random subset of features from the formula, adding variability to the algorithm and reducing computation time. \code{colsample.bytree} will be bounded between
1 and the number of features considered in the formula.}

\item{keep.data}{a boolean variable indicating whether to keep the data frames or not. This is particularly useful if one wants to keep track of the initial data frames
and is further used for predicting in case any data frame is specified.
Note that in case of cross-validation, if \code{keep.data=TRUE} the initial data frames is saved whereas the cross-validation samples are not.}

\item{is.verbose}{if \code{is.verbose=TRUE}, the \code{BT} will print out the algorithm progress.}
}
\value{
a \code{\link{BTFit}} object.
}
\description{
Fit a (Adaptive) Boosting Trees algorithm. This is for "power" users who have a large number of variable and wish to avoid calling
\code{model.frame} which can be slow in this instance. This function is in particular called by \code{\link{BT}}.
It is mainly split in two parts, the first one considers the initialization (see \code{BT_callInit}) whereas the second performs all the boosting iterations (see \code{BT_callBoosting}).
By default, this function does not perform input checks (those are all done in \code{\link{BT}}) and all the parameters should be given in the right format. We therefore
suppose that the user is aware of all the choices made.
}
\references{
M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |: GLMs and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries ||: Tree-Based Methods and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |||: Neural Networks and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2022). \strong{Response versus gradient boosting trees, GLMs and neural networks under Tweedie loss and log-link}.
Accepted for publication in \emph{Scandinavian Actuarial Journal}.

M. Denuit, J. Huyghe and J. Trufin (2022). \strong{Boosting cost-complexity pruned trees on Tweedie responses: The ABT machine for insurance ratemaking}.
Paper submitted for publication.

M. Denuit, J. Trufin and T. Verdebout (2022). \strong{Boosting on the responses with Tweedie loss functions}. Paper submitted for publication.
}
\seealso{
\code{\link{BTFit}}, \code{\link{BTCVFit}}, \code{\link{BT_perf}}, \code{\link{predict.BTFit}},
\code{\link{summary.BTFit}}, \code{\link{print.BTFit}}, \code{\link{BT_cv_errors}}.
}
\author{
Gireg Willame \email{gireg.willame@gmail.com}

\emph{This package is inspired by the \code{gbm3} package. For more details, see \url{https://github.com/gbm-developers/gbm3/}}.
}
