% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_func.R
\name{conv.test}
\alias{conv.test}
\title{convergence test for parameters in the fitted objects}
\usage{
conv.test(params,nchain=3,thshold=1.96)
}
\arguments{
\item{params}{numeric matrix of dimension 2 (iterations x number of parameters, single chain) or 3 (iterations x number of parameters x chain, multiple chains) of posterior samples}

\item{nchain}{positive integer, number of chains used to fit BSTZINB, BSTNB or BSTP}

\item{thshold}{positive scalar, the threshold for testing the convergence. Defaults to 1.96}
}
\value{
logical vector indicating whether convergence was achieved or not
}
\description{
Conducts a test of convergence for a given parameter in the fitted objects using the posterior samples for the said parameter
}
\examples{
data(simdat)
y <- simdat$y
X <- cbind(simdat$V1,simdat$x)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
A <- get_adj_mat(county.adjacency,countyname,c("IA"))
\donttest{
res3 <- BSTZINB(y, X, A, LinearT=TRUE, nchain=3, niter=100, nburn=20, nthin=1)
conv.test(res3$Alpha,nchain=3)
}

}
