% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Statisti}
\alias{Statisti}
\title{Test scores for two beginning statistics classes}
\format{
A data frame/tibble with 62 observations on two variables
\describe{ 
\item{class}{character variable with values \code{Class1} and \code{Class2}} 
\item{score}{test score for an introductory statistics test} 
}
}
\usage{
Statisti
}
\description{
Data for Exercises 1.70 and 1.87
}
\examples{

boxplot(score ~ class, data = Statisti, col = "violet")
tapply(Statisti$score, Statisti$class, summary, na.rm = TRUE)
\dontrun{
library(dplyr)
dplyr::group_by(Statisti, class) \%>\%
 summarize(Mean = mean(score, na.rm = TRUE), 
           Median = median(score, na.rm = TRUE), 
           SD = sd(score, na.rm = TRUE),
           RS = IQR(score, na.rm = TRUE))
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
