% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Skin}
\alias{Skin}
\title{Survival times of closely and poorly matched skin grafts on burn patients}
\format{
A data frame/tibble with 11 observations on four variables
\describe{ 
\item{patient}{patient identification number}
\item{close}{graft survival time in days for a closely matched skin graft on the same burn patient} 
\item{poor}{graft survival time in days for a poorly matched skin graft on the same burn patient} 
\item{differ}{difference between close and poor (in days)}
}
}
\source{
R. F. Woolon and P. A. Lachenbruch, "Rank Tests for Censored Matched Pairs,"
\emph{Biometrika}, 67(1980), 597-606.
}
\usage{
Skin
}
\description{
Data for Exercise 5.20
}
\examples{

stem(Skin$differ)
boxplot(Skin$differ, col = "pink")
summary(Skin$differ)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
