% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Tablrock}
\alias{Tablrock}
\title{Ozone concentrations at Mt. Mitchell, North Carolina}
\format{A data frame/tibble with 719 observations on the following 17 variables.
\describe{ 
\item{day}{date}
\item{hour}{time of day} 
\item{ozone}{ozone concentration}
\item{tmp}{temperature (in Celcius)} 
\item{vdc}{a numeric vector}
\item{wd}{a numeric vector} 
\item{ws}{a numeric vector}
\item{amb}{a numeric vector} 
\item{dew}{a numeric vector}
\item{so2}{a numeric vector} 
\item{no}{a numeric vector}
\item{no2}{a numeric vector} 
\item{nox}{a numeric vector}
\item{co}{a numeric vector} 
\item{co2}{a numeric vector}
\item{gas}{a numeric vector} 
\item{air}{a numeric vector} 
}}
\usage{
Tablrock
}
\description{
Data for Exercise 5.63
}
\examples{

summary(Tablrock$ozone)
boxplot(Tablrock$ozone)
qqnorm(Tablrock$ozone)
qqline(Tablrock$ozone)
par(mar = c(5.1 - 1, 4.1 + 2, 4.1 - 2, 2.1))
boxplot(ozone ~ day, data = Tablrock, 
        horizontal = TRUE, las = 1, cex.axis = 0.7)
        par(mar = c(5.1, 4.1, 4.1, 2.1))
\dontrun{
library(ggplot2)
  ggplot2::ggplot(data = Tablrock, aes(sample = ozone)) + 
             geom_qq() + 
             theme_bw()
  ggplot2::ggplot(data = Tablrock, aes(x = as.factor(day), y = ozone)) + 
             geom_boxplot(fill = "pink") + 
             coord_flip() + 
             labs(x = "") + 
             theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
