\name{BRugsFit} 
\alias{BRugsFit}
\title{BRugs' meta function}
\description{This function takes model, data and starting values as input and automatically runs a simulation in BRugs.}
\usage{
BRugsFit(modelFile, data, inits, numChains = 3, parametersToSave,
    nBurnin = 1000, nIter = 1000, nThin = 1,
    DIC = TRUE, working.directory = NULL, digits = 5)
}
\arguments{
\item{modelFile}{File containing the model written in OpenBUGS code.}
\item{data}{Either a named list (names corresponding to variable names in the \code{modelFile}) 
    of the data for the OpenBUGS model, \emph{or}
    a vector or list of the names of the data objects used by the model.
    In these cases data are written into a file \file{data.txt} into the working directory.
    
    If a filename of an existing file is given, data are read from that file.}
\item{inits}{A list with \code{numChains} elements; each element of the list is
    itself a list of starting values for the OpenBUGS model, \emph{or}
    a function creating (possibly random) initial values.
    In these cases inits are written into files \file{inits1.txt}, \dots, \file{initsN.txt} into the working directory.

    If a vector of filenames of existing files is given, inits are read from those files.
    Alternatively, if \code{inits} is not specified, initial values are generated by OpenBUGS.}
\item{numChains}{Number of Markov chains (default: 3).}
\item{parametersToSave}{Character vector of the names of the parameters to save which should be monitored.}
\item{nBurnin}{Length of burn in (before \code{nIter} iterations start).}
\item{nIter}{Number of iterations (without burn in).}
\item{nThin}{Every \code{nThin}-th iteration of each chain is stored.}
\item{DIC}{Logical, whether to calculate and return the DIC.}
\item{working.directory}{Sets working directory during execution of this function;
    \code{data}, \code{inits} and other files are written to / read from this directory if no other directory 
    is explicitly given in those arguments.
    If \code{NULL}, the current working directory is chosen.}
\item{digits}{Number of significant digits used for OpenBUGS input, see \code{\link{formatC}}.}
}
\value{A list containg components
\item{Stats}{A data frame containing sample statistics. See \code{\link{samplesStats}}.}
\item{DIC}{The DIC statistics, if \code{DIC=TRUE}, else \code{NULL}. See \code{\link{dicStats}}.}
}
\seealso{\code{\link{BRugs}}, \code{\link{help.WinBUGS}}} 
\examples{
BRugsFit(data = "ratsdata.txt", inits = "ratsinits.txt", 
    para = c("alpha", "beta"), modelFile = "ratsmodel.txt", 
    numChains = 1, 
    working.directory = system.file("OpenBUGS", "Examples", 
                                    package = "BRugs"))
}
\keyword{interface}
\concept{OpenBUGS}
\concept{WinBUGS}
\concept{MCMC}
