% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{BNPdens2coda.BNPdens}
\alias{BNPdens2coda.BNPdens}
\title{Export to coda interface}
\usage{
\method{BNPdens2coda}{BNPdens}(object, dens = FALSE)
}
\arguments{
\item{object}{a BNPdens object;}

\item{dens}{logical, it can be TRUE only for models estimated with \code{PYdensity}.
If TRUE, it converts to \code{coda} also the estimated density. Default FALSE.}
}
\value{
an mcmc object
}
\description{
The method \code{BNPdens2coda} converts a \code{BNPdens} object into a \code{coda} mcmc object.
}
\examples{
data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
                  c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
grid <- expand.grid(seq(-7, 7, length.out = 50),
                    seq(-7, 7, length.out = 50))
est_model <- PYdensity(y = data_toy, mcmc = list(niter = 200, nburn = 100),
                       output = list(grid = grid))
coda_mcmc <- BNPdens2coda(est_model)
class(coda_mcmc)

}
