% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{partition}
\alias{partition}
\title{Estimating the partition of the data}
\usage{
partition(object, dist = "VI", max_k = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{BNPdens};}

\item{dist}{a loss function defined on the space of partitions;
it can be variation of information  (\code{"VI"}) or \code{"Binder"}, default \code{"VI"};  see details below}

\item{max_k}{maximum number of clusters passed to the \code{cutree} function; see value below}

\item{...}{additional arguments to be passed}
}
\value{
The function returns a list containing a matrix with \code{nrow(data)} columns and 3 rows. Each row reports
the cluster labels for each observation according to three different approaches, one per row. The first and second rows
are the output of an agglomerative clustering procedure obtained applying the function \code{hclust}
to the dissimilarity matrix (obtained using \code{dist}) and using the complete or average linkage,
respectively. The number of cluster is between 1 and \code{max_k} and is choosen according to a lower bound
on the expected loss as described in Wade and Ghahramani (2018).
The third row reports the partition visited in the MCMC with minimum distance \code{dist} to the dissimilarity matrix.

In addition, the list reports a vector with three scores representing the lower bound on the expected loss
for the three partitions.
}
\description{
The \code{partition} function estimates the partition of the data based on a Bayesian nonparametric mixture
model according to different criteria.
}
\details{
This function returns point estimates for the clustering of the data induced by a nonparametric mixture model.
This result is achieved exploiting two different loss fuctions on the space of partitions: variation of information
 (\code{dist = 'VI'}) and Binder's loss (\code{dist = 'Binder'}). The function is based on the \code{mcclust.ext}
code by Sara Wade (Wade and Ghahramani, 2018).
}
\examples{
data_toy <- c(rnorm(10, -3, 1), rnorm(10, 3, 1))
grid <- seq(-7, 7, length.out = 50)
fit <- PYdensity(y = data_toy, mcmc = list(niter = 100,
                      nburn = 10, nupd = 100), output = list(grid = grid))
class(fit)
partition(fit)

}
\references{
Wade, S.,  Ghahramani, Z. (2018). Bayesian cluster analysis: Point estimation and credible balls.
Bayesian Analysis, 13, 559-626.
}
