% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-save_load.R
\name{load_model}
\alias{load_model}
\title{Load}
\usage{
load_model(model, loc)
}
\arguments{
\item{model}{A BKT model object into which the saved model's attributes will be loaded.}

\item{loc}{Character. The file path from which the model will be loaded, typically an \code{.rds} file.}
}
\value{
The updated BKT model object with the restored attributes from the saved model.
}
\description{
Load a BKT model from a file.
This function loads a previously saved BKT model from an RDS file. The model attributes
are restored into the provided model object, allowing it to be used for further analysis or predictions.
}
\examples{
\donttest{
model <- bkt(seed = 42)
loaded_model <- load_model(model, "bkt_model.rds")
}
}
