% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{convergence}
\alias{convergence}
\title{MCMC Convergence}
\usage{
convergence(object, param = NULL, type = "trace", print_names = FALSE)
}
\arguments{
\item{object}{An object of class \code{estimate} or \code{explore}}

\item{param}{Character string. Names of parameters for which to monitor MCMC convergence.}

\item{type}{Character string. Which type of convergence plot ? The current
options are \code{trace} (default) and \code{acf}.}

\item{print_names}{Logical. Should the parameter names be printed (defaults to \code{FALSE})? This
can be used to first determine the parameter names to specify in \code{type}.}
}
\value{
A list of \code{ggplot} objects.
}
\description{
Monitor convergence of the MCMC algorithms.
}
\note{
An overview of MCMC diagnostics can be found \href{https://sbfnk.github.io/mfiidd/mcmc_diagnostics.html}{here}.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

# data
Y <- ptsd[,1:5]

#########################
###### continuous #######
#########################
fit <- estimate(Y, iter = 250,
                progress = FALSE)

# print names first
convergence(fit, print_names = TRUE)

# trace plots
convergence(fit, type = "trace",
            param = c("B1--B2", "B1--B3"))[[1]]

# acf plots
convergence(fit, type = "acf",
            param = c("B1--B2", "B1--B3"))[[1]]
}
}
