% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.ggm_compare_bf.R
\name{select.ggm_compare_bf}
\alias{select.ggm_compare_bf}
\title{Select Graphical Structure with the Bayes Factor}
\usage{
\method{select}{ggm_compare_bf}(object, BF_cut = 3, ...)
}
\arguments{
\item{object}{object of class \code{ggm_compare_bf}}

\item{BF_cut}{evidentiary threshold}

\item{...}{currently ignored}
}
\value{
list of class \code{select.ggm_compare_bf}

\itemize{
\item \code{BF_10} Bayes factors for the alternative ("not equal")
\item \code{BF_01} Bayes factors for the null hypothesis
\item \code{BF_10_adj} Bayes factor adjacency matrix for the alternative ("not equal")
\item \code{BF_01_adj} Bayes factor adjacency matrix for the null hypothesis
\item \code{adj_10} adjacency matrix for the selected edges (in favor of the "not equal")
\item \code{adj_01} adjacency matrix for the selected edges (in favor of the null hypothesis)
\item \code{pcor_mat_10} partial correlation matrix for the alternative ("not equal")
}
}
\description{
Compare GGMs with the Bayes factor. This method allows for
assessing (relative) evidence for edge equality or edges differences across any number of groups. Further, confirmatory hypothesis testing
can be used to test predictions or expectations regarding difference or similarities in different groups (e.g., male vs. female).
}
\note{
The test provides relative evidence for whether all groups have the same edge strength (for each edge in the model). It is possible to test whether
many groups are all the same. In this case, if there is evidence for the alternative (not equal), information is not immediately available for which group differs
from the others. Thus pairwise group contrasts could be used after testing the equality of more than two groups.
}
\examples{
\donttest{
Y1 <- MASS::mvrnorm(500, rep(0, 16), Sigma = diag(16))
Y2 <- MASS::mvrnorm(500, rep(0, 16), Sigma = diag(16))
Y3 <- MASS::mvrnorm(500, rep(0, 16), Sigma = diag(16))

ggm_bf <- ggm_compare_bf(Y1, Y2, Y3,
                        prior_sd = .20,
                        iter = 500,
                        cores = 2)
# select with BF_cut = 3
ggm_bf_sel <- select(ggm_bf, BF_cut = 3)

# summary
summary(ggm_bf_sel)
}
}
