% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_check.estimate.R
\name{pp_check.estimate}
\alias{pp_check.estimate}
\alias{pp_check}
\title{Posterior Predictive Checks for \code{BGGM} Objects}
\usage{
\method{pp_check}{estimate}(object, iter, type = "stat", ...)
}
\arguments{
\item{object}{object of of class \code{estimate}}

\item{iter}{number of posterior samples used}

\item{type}{type of ppc plot. (\code{type = "xyz"}
provides a list of suppored types)}

\item{...}{currently ignored}
}
\description{
Perform posterior predictive checks with the help
of the \pkg{bayesplot} package (with code taken from \pkg{brms}).
}
\details{
further details are provided here \code{\link[bayesplot:PPC-overview]{PPC}}
}
\examples{
# data
Y <- bfi[,1:5]

# fit model
fit <- estimate(Y)

pp_check(fit, iter = 50,
type = "stat")
}
