% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BETS.save.stata.R
\name{BETS.save.stata}
\alias{BETS.save.stata}
\title{Export a time series to STATA}
\usage{
BETS.save.stata(code = NULL, data = NULL, file.name = "series")
}
\arguments{
\item{code}{An \code{integer}. The unique identifier of the series within the BETS database.}

\item{data}{A \code{data.frame} or a \code{ts}. Contains the data to be written. If \code{data} is supplied, the BETS database will not be searched.}

\item{file.name}{A \code{character}. The name of the output file. The default is 'series.dta'.}
}
\value{
None
}
\description{
Writes a time series to a .dta (STATA) file.
}
\examples{

 #Exchange rate - Free - United States dollar (purchase)
 #us.brl <- BETS.get(3691)
 #requires(seasonal)
 #us.brl.seasonally_adjusted <- seas(us.brl)
 #BETS.save.stata(data = us.brl.seasonally_adjusted,file.name="us.brl.seasonally_adjusted")
 # Or
 #BETS.save.stata(code=3691,file.name="us.brl")

}

