% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Portmanteau_test.R
\name{portmanteau.test}
\alias{portmanteau.test}
\title{Performing a Portmanteau test checking for remaining correlation in the empirical co-variances of the estimated BEKK residuals.}
\usage{
portmanteau.test(x, lags = 5)
}
\arguments{
\item{x}{An object of class "bekkFit" from function \link{bekk_fit}.}

\item{lags}{Either an integer vector or scalar defining the lag length.}
}
\value{
Returns a matrix containing the p-values and test statistics.
}
\description{
Method for a Portmanteau test of the null hypothesis of no remaining correlation in the co-variances of the estimated BEKK residuals.
}
\details{
Here, the multivariate Portmanteau test of Hosking (1980) is implemented.
}
\references{
J. R. M. Hosking (1980). The Multivariate Portmanteau Statistic, Journal of the American Statistical Association, 75:371, 602-608.
}
