% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/largestBeSource.R
\name{largestBeSource}
\alias{largestBeSource}
\title{Autoselect source of biological entity identifiers}
\usage{
largestBeSource(
  be,
  organism,
  rel = NA,
  restricted = TRUE,
  exclude = c("BEDTech_gene", "BEDTech_transcript")
)
}
\arguments{
\item{be}{the biological entity under focus}

\item{organism}{the organism under focus}

\item{rel}{a type of relationship to consider in the query
(e.g. "is_member_of") in order to focus on specific information.
If NA (default) all be are taken into account whatever their available
relationships.}

\item{restricted}{boolean indicating if the results should be restricted to
current version of to BEID db. If FALSE former BEID are also taken
into account.}

\item{exclude}{database to exclude from possible selection. Used to filter
out technical database names such as "BEDTech_gene" and "BEDTech_transcript"
used to manage orphan IDs (not linked to any gene based on information
taken from sources)}
}
\value{
The name of the selected source. The selected source will be the one
providing the largest number of current identifiers.
}
\description{
The selection is based on direct identifiers
}
\examples{
\dontrun{
largestBeSource(be="Gene", "Mus musculus")
}

}
\seealso{
\link{listBeIdSources}
}
