% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOrgNames.R
\name{getOrgNames}
\alias{getOrgNames}
\title{Get organism names from taxonomy IDs}
\usage{
getOrgNames(taxID = NULL)
}
\arguments{
\item{taxID}{a vector of taxonomy IDs. If NULL (default) the function lists
all taxonomy IDs available in the DB.}
}
\value{
A data.frame mapping taxonomy IDs to organism names with the
following fields:
\itemize{
\item \strong{taxID}: the taxonomy ID
\item \strong{name}: the organism name
\item \strong{nameClass}: the class of the name
}
}
\description{
Get organism names from taxonomy IDs
}
\examples{
\dontrun{
getOrgNames(c("9606", "10090"))
getOrgNames("9606")
}

}
\seealso{
\link{getTaxId}, \link{listOrganisms}
}
