#' IMGT Table 2
#'
#' A dataset containing the output from IMGT/HighV-QUEST
#'  IMGT Table 2. The variables are as follows:
#'
#' \itemize{
#'   \item Sequence_number. number of Sequence
#'   \item Sequence_ID. ID frome gene bank
#'   \item Functionality. productive/unproductive
#'   \item V_GENE_and_allele. germline genes of V Region
#'   \item J_GENE_and_allele. germline genes of J Region
#'   \item D_GENE_and_allele. germline genes of D Region
#'   \item V_D_J_REGION. nucleotides in VDJ region in mutated sequence
#'   \item V_J_REGION. NA
#'   \item V_REGION. nucleotides in V region in mutated sequence
#'   \item FR1_IMGT. nucleotides in FR1 in mutated sequence
#'   \item CDR1_IMGT. nucleotides in CDR1 in mutated sequence
#'   \item FR2_IMGT. nucleotides in FR2 in mutated sequence
#'   \item CDR2_IMGT. nucleotides in CDR2 in mutated sequence
#'   \item FR3_IMGT. nucleotides in FR3 in mutated sequence
#'   \item CDR3_IMGT. nucleotides in CDR3 in mutated sequence
#'   \item JUNCTION. nucleotides in JUNCTION region in mutated sequence
#'   \item J_REGION. nucleotides in J region in mutated sequence
#'   \item FR4_IMGT. nucleotides in FR4 in mutated sequence
#'   }
#'
#' @docType data
#' @keywords datasets
#' @name IMGTtab2
#' @usage data(IMGTtab2)
#' @format A data frame with 9 rows and 18 variables
#'
"IMGTtab2"


#' IMGT Table 7
#'
#'  A dataset containing the output from IMGT/HighV-QUEST
#'  IMGT Table 7. The variables are as follows:
#'
#' \itemize{
#'   \item Sequence_number. number of Sequence
#'   \item Sequence_ID. ID frome gene bank
#'   \item Functionality. productive/unproductive
#'   \item V_GENE_and_allele. germline genes of V Region
#'   \item V_REGION. nucleotide changes and aminoacid changes in V region
#'   \item FR1_IMGT. nucleotide changes and aminoacid changes in FR1
#'   \item CDR1_IMGT. nucleotide changes and aminoacid changes in CDR1
#'   \item FR2_IMGT. nucleotide changes and aminoacid changes in FR2
#'   \item  CDR2_IMGT. nucleotide changes and aminoacid changes in CDR2
#'   \item  FR3_IMGT. nucleotide changes and aminoacid changes in FR3
#'   \item CDR3_IMGT. nucleotide changes and aminoacid changes in CDR3
#'   }
#'
#' @docType data
#' @keywords datasets
#' @name IMGTtab7
#' @usage data(IMGTtab7)
#' @format A data frame with 9 rows and 11 variables
#'
"IMGTtab7"



#' IMGT Table 8
#'
#'  A dataset containing the output from IMGT/HighV-QUEST
#'  IMGT Table 8. The variables are as follows:
#'
#' \itemize{
#'   \item Sequence_number. number of Sequence
#'   \item Sequence_ID. ID frome gene bank
#'   \item Functionality. productive/unproductive
#'   \item V_GENE_and_allele. germline genes of V Region
#'   }
#'
#' @docType data
#' @keywords datasets
#' @name IMGTtab8
#' @usage data(IMGTtab8)
#' @format A data frame with 9 rows and 130 variables
#'
"IMGTtab8"

#' Klassen
#'
#'  A dataset for usage of Funktion aa_plotgg_skal()
#'  Klassen. The variables are as follows:
#'
#' \itemize{
#'   \item Egenschaften. Physio-chemical properties of aminoacids
#'   \item Klassen. Classification in classes according to IMGT/HighV-QUEST classes
#'   }
#'
#' @docType data
#' @keywords datasets
#' @name Klassen
#' @usage data(Klassen)
#' @format A data frame with 400 rows and 2 variables
#'
"Klassen"



