% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.bcdagCE.R
\name{print.bcdagCE}
\alias{print.bcdagCE}
\title{bcdagCE object print}
\usage{
\method{print}{bcdagCE}(x, ...)
}
\arguments{
\item{x}{a \code{bcdagCE} object for which a summary is desired}

\item{...}{additional arguments affecting the summary produced}
}
\value{
A printed message listing the inputs given to learn_DAG and get_causaleffect.
}
\description{
This method returns a summary of the inputs given to \code{learn_DAG()} and \code{get_causaleffect()} to obtain the \code{bcdagCE} object.
}
\examples{
q = 8
w = 0.2
set.seed(123)
DAG = rDAG(q = q, w = w)
outDL = rDAGWishart(n = 1, DAG = DAG, a = q, U = diag(1, q))
L = outDL$L; D = outDL$D
Sigma = solve(t(L))\%*\%D\%*\%solve(L)
n = 200
# Generate observations from a Gaussian DAG-model
X = mvtnorm::rmvnorm(n = n, sigma = Sigma)
# Run the MCMC (set S = 5000 and burn = 1000 for better results)
out_mcmc = learn_DAG(S = 500, burn = 100, a = q, U = diag(1,q)/n, data = X, w = w,
                     fast = TRUE, save.memory = FALSE, verbose = FALSE)
out_ce <- get_causaleffect(out_mcmc, targets = c(4,6), response = 1)
print(out_ce)
}
