% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMaxIndex.R
\name{getMaxIndex}
\alias{getMaxIndex}
\alias{getMinIndex}
\alias{getBestIndex}
\title{Return index of maximal/minimal/best element in numerical vector.}
\usage{
getMaxIndex(x, ties.method = "random", na.rm = FALSE)

getMinIndex(x, ties.method = "random", na.rm = FALSE)

getBestIndex(x, minimize = TRUE, ...)
}
\arguments{
\item{x}{[\code{numeric}]\cr
Input vector.}

\item{ties.method}{[\code{character(1)}]\cr
How should ties be handled?
Possible are: \dQuote{random}, \dQuote{first}, \dQuote{last}.
Default is \dQuote{random}.}

\item{na.rm}{[\code{logical(1)}]\cr
If \code{FALSE}, NA is returned if an NA is encountered in \code{x}.
If \code{TRUE}, NAs are disregarded.
Default is \code{FALSE}}

\item{minimize}{[\code{logical(1)}]\cr
Minimal element is considered best?
Default is \code{TRUE}.}

\item{...}{[any]\cr
Further arguments passed down to the delegate.}
}
\value{
[\code{integer(1)}].
}
\description{
If \code{x} is empty or only contains NAs which are to be removed,
-1 is returned.
}
\note{
Function \code{getBestIndex} is a simple wrapper for \code{getMinIndex} or
\code{getMaxIndex} respectively depending on the argument \code{minimize}.
}
