% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LBRecap.all.R
\name{LBRecap.all}
\alias{LBRecap.all}
\title{Standard behavioural and time effect models via unconditional (complete) likelihood approach}
\usage{
LBRecap.all(data, last.column.count=FALSE, neval=1000, by.incr=1,
   which.mod=c("all","standard"), sort=c("default","AIC"))
}
\arguments{
\item{data}{can be one of the following:
\enumerate{
  \item an \eqn{M} by \eqn{t} binary matrix/data.frame
  \item a matrix/data.frame with \eqn{(t+1)} columns according to the value of \cr \code{last.column.count}
  \item a \eqn{t}-dimensional array or table representing the counts of the \eqn{2^t} contingency table of binary outcomes
  \eqn{M} is the number of units captured at least once and \eqn{t} is the number of capture occasions.
  }}

\item{last.column.count}{a logical. In the default case \code{last.column.count=FALSE} each row of \code{data} represents the complete capture history for each observed unit. When code{last.column.count=TRUE} in each row the first \eqn{t} entries represent one of the possible observed complete capture histories and the last entry (last column) is the number of observed units with that capture history}

\item{neval}{a positive integer. \code{neval} is the number of alternative values of the population size N where the likelihood is evaluated and then maximized. They run from the minimum value M and they are increased by \code{by.incr} (see below the description of the \code{by.incr} argument). The default value is \code{neval}=1000.}

\item{by.incr}{a positive integer. \code{by.incr} represents the increment on the sequence of evaluated values for \eqn{N}. The default value is \code{by.incr}=1.}

\item{which.mod}{a character. \code{which.mod} selects which models are fitted and compared. In the default setting \code{which.mod}=\code{"all"} all alternative models are fitted including new behavioural models based on alternative meaningful covariates (see Details). When \code{which.mod}=\code{"standard"} the function only fits classical behavioural models with either enduring effects as in \eqn{M_b}, \eqn{M_{c_1b}}, \eqn{M_{c_2b}} or ephemeral effects as in purely Markovian \eqn{M_{c_1}} and \eqn{M_{c_2}}}

\item{sort}{character. \code{sort} selects the order of models.}
}
\value{
A \code{data.frame} with one row corresponding to each model and the following columns:

model: model considered

npar: number of parameters

AIC: Akaike's information criterion

Nhat: estimate of population size

Ninf: lower \eqn{95 \%} confidence limit

Nsup: upper \eqn{95 \%} confidence limit
}
\description{
Comparative point and interval estimates for the population size \eqn{N} obtained fitting many alternative behavioural and time effect capture-recapture models.
AIC index is reported for each alternative model.
}
\details{
The available models are: \eqn{M_0}, \eqn{M_b}, \eqn{M_t}, \eqn{M_{c_1}}, \eqn{M_{c_1b}}, \eqn{M_{c_2}}, \eqn{M_{c_2b}}, \eqn{M_{mc}},\eqn{M_{mc_{int}}}, \eqn{M_{mc_{count}}} and \eqn{M_{mc_{count.int}}}.
This function \code{LBRecap.all} can be computing intensive for high values of \code{neval}.
}
\examples{
\dontrun{
 data(greatcopper)
 LBRecap.all(greatcopper)
}
}
\references{
Alunni Fegatelli, D. and Tardella, L. (2016), Flexible behavioral capture–recapture modeling. Biometrics, 72(1):125-135. doi:10.1111/biom.12417

Alunni Fegatelli D. (2013) New methods for capture-recapture modelling with behavioural response and individual heterogeneity. http://hdl.handle.net/11573/918752

Alunni Fegatelli D., Tardella L. (2012) Improved inference on capture recapture models with behavioural effects. Statistical Methods & Applications Applications Volume 22, Issue 1, pp 45-66 10.1007/s10260-012-0221-4

Farcomeni A. (2011) Recapture models under equality constraints for the conditional capture probabilities. Biometrika 98(1):237--242

Otis D. L., Burnham K. P., White G. C, Anderson D. R. (1978) Statistical Inference From Capture Data on Closed Animal Populations, Wildlife Monographs.

Yang H.C., Chao A. (2005) Modeling animals behavioral response by Markov chain models for capture-recapture experiments, Biometrics 61(4), 1010-1017
}
\seealso{
\code{\link{LBRecap}}, \code{\link{BBRecap.all}}
}
\author{
Danilo Alunni Fegatelli and Luca Tardella
}
\keyword{Behavioural_models}
\keyword{Unconditional_MLE}
