% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.gamma}
\alias{kernel.gamma}
\title{Gamma diversity using kernel density hypervolumes.}
\usage{
kernel.gamma(comm)
}
\arguments{
\item{comm}{A 'Hypervolume' or 'HypervolumeList' object, preferably built using function kernel.build.}
}
\value{
A single value of gamma.
}
\description{
Estimation of functional richness of multiple sites, based on n-dimensional hypervolumes.
}
\details{
Estimates the functional richness (gamma FD) of multiple communities using kernel density hypervolumes, as implemented in Blonder et al. (2014, 2018).
Functional richness is expressed as the total volume of the n-dimensional hypervolume (Mammola & Cardoso, 2020). Note that the hypervolume is dimensionless, and that only hypervolumes with the same number of dimensions can be compared in terms of functional richness.
Given that the density and positions of stochastic points in the hypervolume are probabilistic, the functional richness of the trait space will intimately depend on the quality of input hypervolumes (details in Mammola & Cardoso, 2020).
}
\examples{
\dontrun{
comm = rbind(c(1,3,2,2,2), c(0,0,0,2,2))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,5), beak = c(1,2,3,4,5))
rownames(trait) = colnames(comm)

hv = kernel.build(comm[1,], trait)
kernel.alpha(hv)
kernel.gamma(hv)
hvlist = kernel.build(comm, trait)
kernel.alpha(hvlist)
kernel.gamma(hvlist)
}
}
\references{
Blonder, B., Lamanna, C., Violle, C. & Enquist, B.J. (2014) The n-dimensional hypervolume. Global Ecology and Biogeography, 23: 595-609.

Blonder, B., Morrow, C.B., Maitner, B., Harris, D.J., Lamanna, C., Violle, C., ... & Kerkhoff, A.J. (2018) New approaches for delineating n-dimensional hypervolumes. Methods in Ecology and Evolution, 9: 305-319.

Mammola, S. & Cardoso, P. (2020) Functional diversity metrics using kernel density n-dimensional hypervolumes. Methods in Ecology and Evolution, 11: 986-995.
}
