% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hull.contribution}
\alias{hull.contribution}
\title{Contribution of each observation to a convex hull hypervolume.}
\usage{
hull.contribution(comm, relative = FALSE)
}
\arguments{
\item{comm}{A 'convhulln' object or list, preferably built with function hull.build.}

\item{relative}{A boolean (T/F) indicating whether contribution should be relative to total PD or FD (proportional contribution per individual or species). If FALSE, the sum of contributions for each site is equal to total PD/FD, if TRUE it is 1.}
}
\value{
A vector or matrix with the contribution values of each species or individual for each site.
}
\description{
Contribution of each species or individual to the total volume of one or more convex hulls.
}
\details{
The contribution of each observation (species or individual) to the total volume of a convex hull, calculated as the difference in volume between the total convex hull and a second hypervolume lacking this specific observation (i.e., leave-one-out approach; Mammola & Cardoso, 2020).
}
\examples{
comm = rbind(c(1,3,0,5,3), c(3,2,5,1,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = colnames(comm)

hv = hull.build(comm[1,], trait)
hull.contribution(hv)
hvlist = hull.build(comm, trait, axes = 2)
hull.contribution(hvlist, relative = TRUE)
}
\references{
Mammola, S. & Cardoso, P. (2020) Functional diversity metrics using kernel density n-dimensional hypervolumes. Methods in Ecology and Evolution. https://doi.org/10.1111/2041-210X.13424
}
