% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{originality}
\alias{originality}
\title{Phylogenetic/functional originality of species or individuals.}
\usage{
originality(comm, tree, distance, abund = TRUE, relative = TRUE)
}
\arguments{
\item{comm}{A sites x species matrix, with either abundance or incidence data. If missing, the originality using the full tree or distance matrix is calculated.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree.}

\item{distance}{A dist object representing the phylogenetic or functional distance between species.}

\item{abund}{A boolean (T/F) indicating whether originality should be calculated per individual (T) or species (F).}

\item{relative}{A boolean (T/F) indicating whether originality should be relative to the maximum distance between any two species in the tree or distance matrix.}
}
\value{
A matrix of sites x species values.
}
\description{
Average dissimilarity between a species or individual and all others in a community.
}
\details{
This is the originality measure of Pavoine et al. (2005) without replacement.
}
\examples{
comm <- matrix(c(1,2,0,0,0,1,1,0,0,0,0,2,2,0,0,0,0,1,1,1), nrow = 4, byrow = TRUE)
distance <- dist(c(1:5), method="euclidean")
tree <- tree.build(1:5)
originality(tree = tree)
originality(distance = distance)
originality(comm, tree)
originality(comm, tree, abund = FALSE)
originality(comm, tree, abund = FALSE, relative = FALSE)
}
\references{
Pavoine, S., Ollier, S. & Dufour, A.-B. (2005) Is the originality of a species measurable? Ecology Letters, 8: 579-586.
}
