% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{sar}
\alias{sar}
\title{Species-area relationship (SAR).}
\usage{
sar(comm, tree, area)
}
\arguments{
\item{comm}{Either a vector with the diversity values per site, or a sites x species matrix.}

\item{tree}{An hclust or phylo object (used only to fit the PD or FD-area relationships, requires comm to be a sites x species matrix).}

\item{area}{A vector with the area per site.}
}
\value{
A matrix with the different model parameters and explanatory power.
}
\description{
Fits and compares several of the most supported models for the species (or PD, or FD) -area relationship.
}
\details{
Larger areas (often islands) usually carry more species. Several formulas were proposed in the past to describe this relationship (Arrhenius 1920, 1921; Gleason 1922).
Recently, the same approach began to be used for other measures of diversity, namely phylogenetic (PD) and functional (FD) diversity (Whittaker et al. 2014).
The function compares some of the most commonly used and theoretically or empirically suported models.
The relationships for PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric).
}
\examples{
div <- c(1,2,3,4,4)
comm <- matrix(c(2,0,0,0,3,1,0,0,2,4,5,0,1,3,2,5,1,1,1,1), nrow = 5, ncol = 4, byrow = TRUE)
tree <- hclust(dist(c(1:4), method="euclidean"), method="average")
area <- c(10,40,80,160,160)
sar(div,,area)
sar(comm,,area)
sar(comm,tree,area)
}
\references{
Arrhenius, O. (1920) Distribution of the species over the area. Meddelanden fran Vetenskapsakadmiens Nobelinstitut, 4: 1-6.

Arrhenius, O. (1921) Species and area. Journal of Ecology, 9: 95-99.

Gleason, H.A. (1922) On the relation between species and area. Ecology, 3: 158-162.

Whittaker, R.J., Rigal, F., Borges, P.A.V., Cardoso, P., Terzopoulou, S., Casanoves, F., Pla, L., Guilhaumon, F., Ladle, R. & Triantis, K.A. (2014) Functional biogeography of oceanic islands and the scaling of functional diversity in the Azores. Proceedings of the National Academy of Sciences USA, 111: 13709-13714.
}
