% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hull.alpha}
\alias{hull.alpha}
\title{Alpha diversity using convex hulls.}
\usage{
hull.alpha(comm, trait, return.hull = FALSE)
}
\arguments{
\item{comm}{A "convhulln" object or a sites x species matrix, with incidence data about the species in the community.}

\item{trait}{A matrix of traits for each species in comm (a species for each row and traits as columns). Must be provided only if 'comm' is a sites x species matrix.}

\item{return.hull}{Boolean indicating whether the generated 'convhulln' objects used to calculate alpha diversity should be returned (default is FALSE).}
}
\value{
A vector of alpha diversity values for each site. If return.hull is set to TRUE, the function also returns the list of convex hulls used to compute alpha diversity.
}
\description{
Estimation of functional richness of one or multiple sites, based on convex hull.
}
\details{
Estimates the functional richness (alpha FD) of one or more communities using convex hull. Note that a minimum of 4 observations for each community are needed to generate the convex hull. 
Functional richness is expressed as the total volume of the convex hull.
}
\examples{
comm <- rbind(c(1,1,1,1,1), c(1,1,1,1,1), c(0,0,1,1,1),c(0,0,1,1,1))
rownames(comm) = c("Community_1","Community_2","Community_3","Community_4")
colnames(comm) = c("Sp_1","Sp_2","Sp_3","Sp_4", "Sp_5")

trait <- cbind(c(2.2,4.4,6.1,8.3,3),c(0.5,1,0.5,0.4,4),c(0.7,1.2,0.5,0.4,5),c(0.7,2.2,0.5,0.3,6))
rownames(trait) = c("Sp_1","Sp_2","Sp_3","Sp_4","Sp_5")
colnames(trait) = c("Trait_1","Trait_2","Trait_3","Trait_4")

#example with convex hull as imput
hull.alpha(geometry::convhulln(trait,options = "FA"))

#example with comm and trait as imput
hull.alpha(comm = comm, trait = trait, return.hull = FALSE)

alpha_hull <- hull.alpha(comm = comm, trait = trait, return.hull = TRUE)
alpha_hull[[1]] #alpha diversity
alpha_hull[[2]] #list of convex hulls
}
