% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{raster.beta}
\alias{raster.beta}
\title{Maps of beta diversity (Taxon, Phylogenetic or Functional Diversity - TD, PD, FD).}
\usage{
raster.beta(layers, tree, func = "jaccard", neighbor = 8, abund = FALSE)
}
\arguments{
\item{layers}{A SpatRaster object of species distributions from package terra.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree.}

\item{func}{Partial match indicating whether the Jaccard or Soerensen family of beta diversity measures should be used. If not specified, default is Jaccard.}

\item{neighbor}{Either 8 (default) or 4 cells considered to calculate beta diversiy of each focal cell.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used (TRUE) or converted to incidence (FALSE) before analysis.}
}
\value{
A SpatRaster object with five layers representing Btotal, Brepl, Brich, Bgain and Bloss in space.
}
\description{
Observed beta diversity using rasters of species distributions (presence/absence or abundance).
}
\details{
The beta diversity metrics follow the partitioning frameworks developed by Podani & Schmera (2011), Carvalho et al. (2012) and Legendre (2019)
and later expanded to PD and FD by Cardoso et al. (2014), where Btotal = Brepl + Brich or Btotal = Bgain + Bloss.
Btotal = total beta diversity, reflecting both volume replacement and loss/gain;
Brepl = beta diversity explained by replacement of volume alone; Brich = beta diversity explained by volume loss/gain (richness differences) alone;
Bgain = beta diversity explained by volume gain from T1 to T2; Bloss = beta diversity explained by volume lost from T1 to T2.
PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric). The path to the root of the tree is always included in calculations of PD and FD.
The number and order of species in layers must be the same as in tree.
}
\examples{
sp1 <- terra::rast(matrix(c(NA,1,1,1,1,0,0,0,0), nrow = 3, ncol = 3, byrow = TRUE))
sp2 <- terra::rast(matrix(c(0,0,0,0,1,1,1,1,1), nrow = 3, ncol = 3, byrow = TRUE))
sp3 <- terra::rast(matrix(c(0,0,0,1,1,1,0,0,0), nrow = 3, ncol = 3, byrow = TRUE))
spp <- c(sp1, sp2, sp3)
names(spp) = c("Sp1", "Sp2", "Sp3")

tree <- tree.build(gower(1:3))
tree$tip.label = names(spp)

raster.beta(spp)
raster.beta(spp, tree)
}
\references{
Cardoso, P., Rigal, F., Carvalho, J.C., Fortelius, M., Borges, P.A.V., Podani, J. & Schmera, D. (2014) Partitioning taxon, phylogenetic and functional beta diversity into replacement and richness difference components. Journal of Biogeography, 41, 749-761.

Carvalho, J.C., Cardoso, P. & Gomes, P. (2012) Determining the relative roles of species replacement and species richness differences in generating beta-diversity patterns. Global Ecology and Biogeography, 21, 760-771.

Gotelli, N.J. & Colwell, R.K. (2001) Quantifying biodiversity: procedures and pitfalls in the measurement and comparison of species richness. Ecology Letters, 4, 379-391.

Podani, J. & Schmera, D. (2011) A new conceptual and methodological framework for exploring and explaining pattern in presence-absence data. Oikos, 120, 1625-1638.
}
