% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{plot.confint.bas}
\alias{plot.confint.bas}
\title{Plot Bayesian Confidence Intervals}
\usage{
\method{plot}{confint.bas}(x, horizontal = FALSE, ...)
}
\arguments{
\item{x}{the output from \code{\link{confint.coef.bas}} or
\code{\link{confint.pred.bas}} containing credible intervals and estimates.}

\item{horizontal}{orientation of the plot}

\item{...}{optional graphical arguments to pass on to plot}
}
\value{
A plot of the credible intervals.
}
\description{
Function takes the the output of functions that return credible intervals
from BAS objects, and creates a plot of the posterior mean with segments
representing the credible interval.  %% ~~ A concise (1-5 lines) description
of what the function does. ~~
}
\details{
This function takes the HPD intervals or credible intervals created by
\code{\link{confint.coef.bas}} or \code{\link{confint.pred.bas}} from BAS
objects, and creates a plot of the posterior mean with segments representing
the credible interval.  BAS tries to return HPD intervals, and under model
averaging these may not be symmetric.  %% ~~ If necessary, more details than
the description above ~~
}
\examples{

data(Hald)
hald.ZS = bas.lm(Y ~ ., data=Hald, prior="ZS-null", modelprior=uniform())
hald.coef = confint(coef(hald.ZS), parm=2:5)
plot(hald.coef)
plot(hald.coef, horizontal=TRUE)
plot(confint(predict(hald.ZS, se.fit=TRUE), parm="mean"))

}
\seealso{
\code{\link{confint.coef.bas}}, \code{\link{confint.pred.bas}},
\code{\link{coef.bas}}, \code{\link{predict.bas}}, \code{link{bas.lm}}

Other bas methods: 
\code{\link{BAS}},
\code{\link{bas.lm}()},
\code{\link{coef.bas}()},
\code{\link{confint.coef.bas}()},
\code{\link{confint.pred.bas}()},
\code{\link{diagnostics}()},
\code{\link{fitted.bas}()},
\code{\link{force.heredity.bas}()},
\code{\link{image.bas}()},
\code{\link{predict.bas}()},
\code{\link{predict.basglm}()},
\code{\link{summary.bas}()},
\code{\link{update.bas}()},
\code{\link{variable.names.pred.bas}()}

Other CI methods: 
\code{\link{confint.coef.bas}()},
\code{\link{confint.pred.bas}()}
}
\author{
Merlise A Clyde
}
\concept{CI methods}
\concept{bas methods}
\keyword{bayesian}
\keyword{regression}
