% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPM.HODC.R
\name{DPM.HODC}
\alias{DPM.HODC}
\title{Hierachical ordered density clustering (HODC) Algorithm with input generated by DPdensity}
\usage{
DPM.HODC(v, pvalue, DPM.mcmc = list(nburn = 2000, nsave = 1, nskip = 0,
  ndisplay = 10), DPM.prior = list(a0 = 2, b0 = 1, m2 = rep(0, 1), s2 =
  diag(1e+05, 1), psiinv2 = solve(diag(0.5, 1)), nu1 = 4, nu2 = 4, tau1 = 1,
  tau2 = 100))
}
\arguments{
\item{v}{number of iterations set for DPM fitting by "DPdensity"}

\item{pvalue}{a vector of p-values obtained from large scale statistical hypothesis testing}

\item{DPM.mcmc}{list}

\item{DPM.prior}{list}
}
\value{
a list of HODC algorithm returned parameters.
\describe{
\item{mean}{the means of each of two cluster for every DPM fitting by "DPdensity"
\describe{
\item{mu0}{the means of the cluster with smaller mean}
\item{mu1}{the means of the cluster with larger mean}
}
}
\item{variance}{the variance of each of two cluster for every DPM fitting by "DPdensity"
\describe{
\item{var0}{the variances of the cluster with smaller mean}
\item{var1}{the variances of the cluster with larger mean}
}
}
\item{probability}{the probability of each of two cluster for every DPM fitting by "DPdensity"
\describe{
\item{pro0}{the probabilities of the cluster with smaller mean}
\item{pro1}{the probabilities of the cluster with larger mean}
}
}
\item{classification}{The classification corresponding to each cluster for every DPM fitting by "DPdensity"}
}
}
\description{
Hierachical ordered density clustering (HODC) Algorithm with input generated by DPdensity
}
\details{
Without the information of networking, we can have an approximation to the marginal density by DPM model fitting on \strong{r}. Suppose the number of finite mixture normals is equal to L_0+L_1, which means the number of classes we have, we apply HODC algorithm in partitioning the $L_0$ and $L_1$ components into two classes.
For this function, the input is generated by Mclust
}
\examples{
\dontrun{
###random make the density
rstat=c(rnorm(50,mean=1),rnorm(50,mean=2),rnorm(100,mean=4),rnorm(100,mean=8))
###transformed into pvalue
pvalue=pnorm(-rstat)
dpdensityHODC=DPM.HODC(v=5,pvalue)
}
}
