% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_config.R
\name{ip_config}
\alias{ip_config}
\title{Public IP address configuration}
\usage{
ip_config(type = NULL, dynamic = NULL, ipv6 = FALSE,
  domain_name = "[parameters('vmName')]", ...)
}
\arguments{
\item{type}{The SKU of the IP address resource: "basic" or "standard". If NULL (the default), this will be determined based on the VM's configuration.}

\item{dynamic}{Whether the IP address should be dynamically or statically allocated. Note that the standard SKU only supports standard allocation. If NULL (the default) this will be determined based on the VM's configuration.}

\item{ipv6}{Whether to create an IPv6 address. The default is IPv4.}

\item{domain_name}{The domain name label to associate with the address.}

\item{...}{Other named arguments that will be treated as resource properties.}
}
\description{
Public IP address configuration
}
\examples{
ip_config()
ip_config(type="basic", dynamic=TRUE)

# if you don't want a domain name associated with the IP address
ip_config(domain_name=NULL)
}
\seealso{
\link{create_vm}, \link{vm_config}, \link{vmss_config}
}
