% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blob_snapshot.R
\name{create_blob_snapshot}
\alias{create_blob_snapshot}
\alias{list_blob_snapshots}
\alias{delete_blob_snapshot}
\title{Create, list and delete blob snapshots}
\usage{
create_blob_snapshot(container, blob, ...)

list_blob_snapshots(container, blob)

delete_blob_snapshot(container, blob, snapshot, confirm = TRUE)
}
\arguments{
\item{container}{A blob container.}

\item{blob}{The path/name of a blob.}

\item{...}{For \code{create_blob_snapshot}, an optional list of name-value pairs that will be treated as the metadata for the snapshot. If no metadata is supplied, the metadata for the base blob is copied to the snapshot.}

\item{snapshot}{For \code{delete_blob_snapshot}, the specific snapshot to delete. This should be a datetime string, in the format \code{yyyy-mm-ddTHH:MM:SS.SSSSSSSZ}. To delete \emph{all} snapshots for the blob, set this to \code{"all"}.}

\item{confirm}{Whether to ask for confirmation on deleting a blob's snapshots.}
}
\value{
For \code{create_blob_snapshot}, the datetime string that identifies the snapshot.

For \code{list_blob_snapshots} a vector of such strings, or NULL if the blob has no snapshots.
}
\description{
Create, list and delete blob snapshots
}
\details{
Blobs can have \emph{snapshots} associated with them, which are the contents and optional metadata for the blob at a given point in time. A snapshot is identified by the date and time on which it was created.

\code{create_blob_snapshot} creates a new snapshot, \code{list_blob_snapshots} lists all the snapshots, and \code{delete_blob_snapshot} deletes a given snapshot or all snapshots for a blob.

Note that snapshots are only supported if the storage account does NOT have hierarchical namespaces enabled.
}
\examples{
\dontrun{

cont <- blob_container("https://mystorage.blob.core.windows.net/mycontainer", key="access_key")

snap_id <- create_blob_snapshot(cont, "myfile", tag1="value1", tag2="value2")

list_blob_snapshots(cont, "myfile")

get_storage_properties(cont, "myfile", snapshot=snap_id)

# returns list(tag1="value1", tag2="value2")
get_storage_metadata(cont, "myfile", snapshot=snap_id)

download_blob(cont, "myfile", snapshot=snap_id)

# delete all snapshots
delete_blob_snapshots(cont, "myfile", snapshot="all")

}
}
\seealso{
Other AzureStor functions that support blob snapshots by passing a \code{snapshot} argument: \link{download_blob}, \link{get_storage_properties}, \link{get_storage_metadata}
}
