% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_storage.R
\docType{class}
\name{az_storage}
\alias{az_storage}
\title{Storage account resource class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
az_storage
}
\description{
Class representing a storage account, exposing methods for working with it.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new storage object. See 'Initialization'.
\item \code{list_keys()}: Return the access keys for this account.
\item \code{get_account_sas(...)}: Return an account shared access signature (SAS). See 'Shared access signatures' for more details.
\item \code{get_blob_endpoint(key, sas)}: Return the account's blob storage endpoint, along with an access key and/or a SAS. See 'Endpoints' for more details
\item \code{get_file_endpoint(key, sas)}: Return the account's file storage endpoint.
\item \code{regen_key(key)}: Regenerates (creates a new value for) an access key. The argument \code{key} can be 1 or 2.
}
}

\section{Initialization}{

Initializing a new object of this class can either retrieve an existing storage account, or create a account on the host. Generally, the best way to initialize an object is via the \code{get_storage_account}, \code{create_storage_account} or \code{list_storage_accounts} methods of the \link{az_resource_group} class, which handle the details automatically.
}

\section{Shared access signatures}{

The simplest way for a user to access files and data in a storage account is to give them the account's access key. This gives them full control of the account, and so may be a security risk. An alternative is to provide the user with a \emph{shared access signature} (SAS), which limits access to specific resources and only for a set length of time.

To create an account SAS, call the \code{get_account_sas()} method with the following arguments:
\itemize{
\item \code{start}: The starting access date/time, as a \code{Date} or \code{POSIXct} value. Defaults to the current time.
\item \code{expiry}: The ending access date/time, as a \code{Date} or \code{POSIXct} value.  Defaults to 8 hours after the start time.
\item \code{services}: Which services to allow access to. A string containing a combination of the letters \code{b}, \code{f}, \code{q}, \code{t} for blob, file, queue and table access. Defaults to \code{bfqt}.
\item \code{permissions}: Which permissions to grant. A string containing a combination of the letters \code{r} (read), \code{w} (write), \code{d} (delete), \code{l} (list), \code{a} (add), \code{c} (create), \code{u} (update) , \code{p} (process). Defaults to \code{r}.
\item \code{resource_types}: Which levels of the resource type hierarchy to allow access to. A string containing a combination of the letters \code{s} (service), \code{c} (container), \code{o} (object). Defaults to \code{sco}.
\item ip: An IP address or range to grant access to.
\item \code{protocol}: Which protocol to allow, either \code{"http"}, \code{"http,https"} or \code{"https"}. Defaults to NULL, which is the same as \code{"http,https"}.
\item \code{key}: the access key used to sign (authorise) the SAS.
}
}

\section{Endpoints}{

The client-side interaction with a storage account is via an \emph{endpoint}. A storage account can have several endpoints, one for each type of storage supported: blob, file, queue and table.

The client-side interface in AzureStor is implemented using S3 classes. This is for consistency with other data access packages in R, which mostly use S3. It also emphasises the distinction between Resource Manager (which is for interacting with the storage account itself) and the client (which is for accessing files and data stored in the account).

To create a storage endpoint independently of Resource Manager (for example if you are a user without admin or owner access to the account), use the \link{blob_endpoint} or \link{file_endpoint} functions.

If a storage endpoint is created without an access key and SAS, only public (anonymous) access is possible.
}

\examples{
\dontrun{

# recommended way of retrieving a resource: via a resource group object
stor <- resgroup$get_storage_account("mystorage")

# list account access keys
stor$list_keys()

# regenerate a key
stor$regen_key(1)

# generate a shared access signature for blob storage, expiring in 7 days time
today <- Sys.time()
stor$get_account_sas(expiry=today + 7*24*60*60, services="b", permissions="rw")

# storage endpoints
stor$get_blob_endpoint()
stor$get_file_endpoint()

}
}
\seealso{
\link{blob_endpoint}, \link{file_endpoint},
\link{create_storage_account}, \link{get_storage_account}, \link{delete_storage_account}, \link{Date}, \link{POSIXt},
\href{https://docs.microsoft.com/en-us/rest/api/storagerp/}{Azure Storage Provider API reference},
\href{https://docs.microsoft.com/en-us/rest/api/storageservices/}{Azure Storage Services API reference}
}
\keyword{datasets}
