% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_client_funcs.R
\name{list_azure_files}
\alias{list_azure_files}
\alias{upload_azure_file}
\alias{download_azure_file}
\alias{delete_azure_file}
\alias{create_azure_dir}
\alias{delete_azure_dir}
\title{Operations on a file share}
\usage{
list_azure_files(share, dir, info = c("all", "name"), prefix = NULL)

upload_azure_file(share, src, dest, blocksize = 2^24)

download_azure_file(share, src, dest, overwrite = FALSE)

delete_azure_file(share, file, confirm = TRUE)

create_azure_dir(share, dir)

delete_azure_dir(share, dir, confirm = TRUE)
}
\arguments{
\item{share}{A file share object.}

\item{dir, file}{A string naming a directory or file respectively.}

\item{info}{Whether to return names only, or all information in a directory listing.}

\item{prefix}{For \code{list_azure_files}, filters the result to return only files and directories whose name begins with this prefix.}

\item{src, dest}{The source and destination filenames for uploading and downloading. Paths are allowed.}

\item{blocksize}{The number of bytes to upload per HTTP(S) request.}

\item{overwrite}{When downloading, whether to overwrite an existing destination file.}

\item{confirm}{Whether to ask for confirmation on deleting a file or directory.}
}
\value{
For \code{list_azure_files}, if \code{info="name"}, a vector of file/directory names. If \code{info="all"}, a data frame giving the file size and whether each object is a file or directory.
}
\description{
Upload, download, or delete a file; list files in a directory; create or delete directories.
}
\examples{
\dontrun{

share <- file_share("https://mystorage.file.core.windows.net/myshare", key="access_key")

list_azure_files(share, "/")

create_azure_dir(share, "/newdir")

upload_azure_file(share, "~/bigfile.zip", dest="/newdir/bigfile.zip")
download_azure_file(share, "/newdir/bigfile.zip", dest="~/bigfile_downloaded.zip")

delete_azure_file(share, "/newdir/bigfile.zip")
delete_azure_dir(share, "/newdir")

}
}
\seealso{
\link{file_share}, \link{az_storage}
}
