% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfg.R
\name{config}
\alias{config}
\title{Configure Azure Application Insights}
\usage{
config(
  appId,
  instrumentationKey,
  connectionString,
  autoTrackPageVisitTime = TRUE,
  ...
)
}
\arguments{
\item{appId}{String for identifying your app, if you use same Application Insights for multiple apps.}

\item{instrumentationKey, connectionString}{\code{connectionString} is preferred for newer
accounts. Must contain both \code{InstrumentationKey} and \code{IngestionEndpoint}.}

\item{autoTrackPageVisitTime}{Submits how long time a user spent on the *previous* page (see website for more information).}

\item{...}{Additional options, as given in \url{https://docs.microsoft.com/en-us/azure/azure-monitor/app/javascript#configuration}.
No checks performed here.}
}
\value{
List.
}
\description{
Ensures an instrumentationKey/connectionString and appId is provided.
}
\details{
See https://docs.microsoft.com/en-us/azure/azure-monitor/app/javascript#configuration
for explanation of options.

If jsonlite is playing tricks on the arguments given, wrap the value with \code{I}.
E.g. if you want to force an atomic vector of length 1 to be parsed as an array, use
\code{I(3.14)}.
}
