% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PCoC_main.R
\name{pcoc}
\alias{pcoc}
\title{PCoC for correcting for population stratification}
\usage{
pcoc(genoFile = "pcocG.eg.txt", outFile.txt = "pcoc.result.txt",
  n.MonterCarlo = 1000, num.splits = 10, miss.val = 9)
}
\arguments{
\item{genoFile}{a txt file containing the genotypes (0, 1, 2, or
9). The element of the file in Row \emph{i} and Column \emph{j}
represents the genotype at the \emph{i}th marker of the \emph{j}th
subject. 0, 1, and 2 denote the number of risk alleles, and 9
(default) is for the missing genotype.}

\item{outFile.txt}{a txt file for saving the result of this
function.}

\item{n.MonterCarlo}{the number of times for the Monter Carlo
procedure. The default is 1000.}

\item{num.splits}{the number of groups into which the markers are
split. The default is 10.}

\item{miss.val}{the number representing the missing data in the
input data. The default is 9. The element 9 for the missing data
in the \code{genoFile} should be changed according to the value of
\code{miss.val}.}
}
\value{
A list of \code{principal.coordinates} and
\code{cluster}. \code{principal.coordinates} is the principal
coordinates and \code{cluster} is the clustering of the
subjects. If the number of the clusters is only one,
\code{cluster} is omitted.
}
\description{
Identify the clustered and continuous patterns of the genetic
variation using the PCoC, which calculates the principal
coordinates and the clustering of the subjects for correcting for
PS.
}
\details{
The hidden population structure is a possible confounding effect
in the large-scale genome-wide association studies. Cases and
controls might have systematic differences because of the
unrecognized population structure. The PCoC procedure uses the
techniques from the multidimensional scaling and the clustering to
correct for the population stratification. The PCoC could be seen
as an extension of the EIGENSTRAT.
}
\examples{
pcocG.eg <- matrix(rbinom(4000, 2, 0.5), ncol = 40)
write.table(pcocG.eg, file = "pcocG.eg.txt", quote = FALSE,
       sep = "", row.names = FALSE, col.names = FALSE)
pcoc(genoFile = "pcocG.eg.txt", outFile.txt = "pcoc.result.txt",
       n.MonterCarlo = 50, num.splits = 10, miss.val = 9)
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}
\references{
Q Li and K Yu. Improved correction for population
stratification in genome-wide association studies by identifying
hidden population structures. \emph{Genetic Epidemiology}. 2008;
32(3): 215-226.

KV Mardia, JT Kent, and JM Bibby. Multivariate
analysis. \emph{New York: Academic Press}. 1976.
}

