% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise.mesh.R
\name{noise.mesh}
\alias{noise.mesh}
\title{noise.mesh}
\usage{
noise.mesh(mesh, noise = 0.025, seed = 123)
}
\arguments{
\item{mesh}{triangular mesh stored as object of class "mesh3d"}

\item{noise}{sd deviation to define vertex noise}

\item{seed}{seed for random number generator}
}
\value{
mesh_n a 3D model of class "mesh3d" with noise
}
\description{
This function adds noise to a mesh
}
\examples{
#load mesh
library(compositions)
library(rgl)
data("SCP1.mesh")
mesh<-SCP1.mesh
#add noise
noised<-noise.mesh(mesh,noise=0.05)
#plot original and mesh with noise added
open3d()
shade3d(mesh,col=3)
shade3d(noised,col=2,add=TRUE)
}
\author{
Antonio Profico, Alessio Veneziano, Marina Melchionna, Pasquale Raia
}
