% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiMarginalPlot.R
\name{multi_marginal_plot}
\alias{multi_marginal_plot}
\title{Marginal posterior densities of several events}
\usage{
multi_marginal_plot(
  data,
  position = 1:ncol(data),
  level = 0.95,
  grid_length = 1024,
  x_scale = "calendar",
  elapsed_origin_position = NULL,
  title = "Characteristics of several dates",
  subtitle = "Marginal densities",
  caption = paste(level * 100, "\% credible interval", sep = ""),
  x_label = "Calendar year",
  y_label = NULL,
  density_fill = "gray30",
  density_color = "black",
  density_alpha = 1,
  mean_color = "white",
  mean_linetype = "dashed",
  mean_size = 0.5,
  ci_color = mean_color,
  ci_linetype = "dotted",
  ci_size = mean_size,
  y_grid = TRUE,
  x_min = NULL,
  x_max = NULL,
  height = 7,
  width = 7,
  units = "in",
  file = NULL,
  new_window = TRUE,
  plot_result = TRUE,
  fill_palette = NULL,
  colors = NULL,
  color_legend_name = "Legend"
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest, or a vector of column names.}

\item{level}{Probability corresponding to the level of confidence.}

\item{grid_length}{Number of equally spaced points at which the
density is to be estimated (for \code{density()} function).}

\item{x_scale}{One of "calendar" for calendar years,
"BP" for years before present,
or "elapsed" for time elapsed from a specified origin.}

\item{elapsed_origin_position}{Position of the column to use
as the origin for elapsed time calculations.}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{x_label}{Label of the x-axis.}

\item{y_label}{Label of the y-axis.}

\item{density_fill}{A color specification for the fill under the
density line.}

\item{density_color}{A color specification for the density line.}

\item{density_alpha}{A number between 0 for transparent and 1
for opaque.}

\item{mean_color}{A color specification for the mean line.}

\item{mean_linetype}{A line type specification for the mean line.}

\item{mean_size}{A size specification for the mean line.}

\item{ci_color}{A color specification for the credible interval lines.}

\item{ci_linetype}{A line type specification for the credible interval
lines.}

\item{ci_size}{A size specification of the credible interval lines.}

\item{y_grid}{Switch for horizontal grid lines.}

\item{x_min}{Minimum x-axis value.}

\item{x_max}{Maximum x-axis value.}

\item{height}{Plot height in \code{units}.}

\item{width}{Plot width in \code{units}.}

\item{units}{String recognized by the \code{ggsave()} function,
one of "in", "cm", "mm".}

\item{file}{Name of the file that will be saved if specified,
default = \code{NULL}.}

\item{new_window}{Whether or not the plot is drawn within a new window.}

\item{plot_result}{If \code{TRUE}, then draw a plot on the display,
else suppress drawing.}

\item{fill_palette}{A vector of colors for qualitative data.}

\item{colors}{A vector of indices into palette keyed by position.}

\item{color_legend_name}{A label for the legend.}
}
\value{
An \code{archaeophases_plot} object with the data and metadata
needed to reproduce the plot.
}
\description{
Draws a plot of the estimated marginal posterior density for a parameter
and adds the mean and the credible interval at the desired level
}
\details{
The density is estimated using \code{density()} function with
n = \code{grid_length.} The input MCMC chains should either be in
calendar years or converted to calendar years using \code{x_scale} vector or
\code{elapsed_origin_position}.
}
\examples{
  data(Events);
  multi_marginal_plot(Events, position = c(2, 3, 4), level = 0.95)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr};

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}; and

Thomas S. Dye, \email{tsd@tsdye.online}
}
