% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatesHiatus.R
\name{dates_hiatus}
\alias{dates_hiatus}
\title{Test for the existence of a hiatus between two MCMC chains.}
\usage{
dates_hiatus(a_chain, b_chain, level = 0.95)
}
\arguments{
\item{a_chain}{: Numeric vector containing the output of the MCMC
algorithm for the first parameter.}

\item{b_chain}{: Numeric vector containing the output of the MCMC
algorithm for the second parameter.}

\item{level}{Probability corresponding to the confidence level of the
interval.}
}
\value{
A list with the following components:
\describe{
\item{hiatus}{A named vector where \code{inf} is the lower endpoint of the
hiatus as a calendar year (AD/BC) or \code{NA} if there is no hiatus at
\code{level}, and \code{sup} is the upper endpoint of the gap as a calendar
year (AD/BC), or \code{NA} if there is no hiatus at \code{level}.}
\item{duration}{The duration of the hiatus at \code{level}.}
\item{level}{Probability corresponding to the confidence level of the
interval.}
\item{call}{The function call.}
}
}
\description{
Determines whether there is a hiatus between two MCMC chains and returns
the longest interval that satisfies:
\eqn{P(a_chain < IntervalInf < IntervalSup < b_chain | M) = level}
}
\examples{
  data(Events); attach(Events)
  dates_hiatus(Event.1, Event.12)
  dates_hiatus(Event.1, Event.12, level = 0.5)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}, and

Thomas S. Dye, \email{tsd@tsdye.online}
}
