% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarginalStatistics.R
\name{marginal_statistics}
\alias{marginal_statistics}
\title{Marginal summary statistics}
\usage{
marginal_statistics(a_chain, level = 0.95, round_to = 0)
}
\arguments{
\item{a_chain}{Numeric vector containing the output of the MCMC
algorithm for the parameter.}

\item{level}{Probability corresponding to the level of confidence
used for the credible interval and the highest posterior density region.}

\item{round_to}{Integer indicating the number of decimal places.}
}
\value{
A list with the following components:
\describe{
\item{mean}{The mean of the MCMC chain.}
\item{map}{The maximum a posteriori of the MCMC chain.}
\item{sd}{The standard deviation of the MCMC chain.}
\item{quantiles}{A vector with the following elements:
\code{min} = minimum value of the MCMC chain;
\code{q1} = first quantile of the MCMC chain;
\code{median} = median of the MCMC chain;
\code{q2} = second quantile of the MCMC chain; and
\code{max} = maximum value of the MCMC chain.}
\item{level}{Confidence level for the credible interval
and highest posterior density.}
\item{ci}{A vector with the following elements:
\code{inf} = lower credible interval of the MCMC chain at \code{level}; and
\code{sup} = upper credible interval of the MCMC chain at \code{level}.
}
\item{hpdr}{A variable length vector with the lower and upper highest
posterior density regions of the MCMC chain at \code{level}.  List
components are named \code{inf_n} and \code{sup_n} for n = 1 to the
number of highest posterior density regions.}
}
}
\description{
Calculates summary statistics of the output of the MCMC algorithm for a
single parameter. Results are given in calendar years (BC/AD).
}
\details{
The \eqn{(100 * level)}\\% highest posterior density region is estimated
using \code{hdr()} function from \pkg{hdrcde} package.
}
\examples{
  data(Events); attach(Events)
  marginal_statistics(Event.1)
  marginal_statistics(Event.2, level = 0.90)
  ## convenient vector
  foo <- marginal_statistics(Event.1)
  unlist(foo)

}
\references{
Hyndman, R. J. (1996) Computing and graphing highest density regions.
American Statistician, 50, 120-126.
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}, and

Thomas S. Dye, \email{tsd@tsdye.online}
}
